{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 13.08.98 - 21:15:56 $                                        =}
{========================================================================}
unit Form_Capture;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, MMObj, MMDIBCv, MMLevel, MMCCon, MMDSCon, MMDSMix, MMWave,
  MMDSPObj, MMDSCptr, MMCstDlg, MMHook, MMDesign, ExtCtrls, bsSkinCtrls,
  BusinessSkinForm, MMBmpLst, MMBmpBtn, MMPanel, MMFill,dateutils,mmmpeg,MMUtils,
  bsSkinShellCtrls, bsSkinBoxCtrls, MMWRec, MMConect;

type
  TFormCapture = class(TForm)
    MMDesigner1: TMMDesigner;
    Timer1: TTimer;
    skin: TbsBusinessSkinForm;
    bsSkinStatusBar1: TbsSkinStatusBar;
    bsSkinPanel4: TbsSkinPanel;
    MMPanelFill2: TMMPanelFill;
    StartBtn: TMMBitmapButton;
    StopBtn: TMMBitmapButton;
    Total: TMMPanelFill;
    MMPanelFill5: TMMPanelFill;
    SaveBtn: TMMBitmapButton;
    FormatBtn: TMMBitmapButton;
    MMLevel1: TMMLevel;
    MMLevel2: TMMLevel;
    MMWaveSaveDialog1: TbsSkinSaveDialog;
    bsSkinSpinEdit1: TbsSkinSpinEdit;
    StaticText1: TStaticText;
    StaticText2: TStaticText;
    lock: TbsSkinCheckRadioBox;
    WaveRecorder: TMMWaveRecorder;
    MMConnector1: TMMConnector;
    procedure FormatBtnClick(Sender: TObject);
    procedure StartBtnClick(Sender: TObject);
    procedure StopBtnClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure lockClick(Sender: TObject);
    procedure WaveRecorderStop(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FormCapture: TFormCapture;
  resultmin:string;

implementation

uses form_mainform;

{$R *.DFM}

function MSecToTime(times: Int64): string;
Var
   Hour, Min, Sec, MSec : Word;
   text:string;
begin
   text:='';
   TimeDecode(times, Hour, Min, Sec, MSec);
   text:=inttostr(hour)+':'+inttostr(min)+':'+inttostr(Sec);
   result:=text;
   resultmin:=inttostr(min);
end;

procedure TFormCapture.FormatBtnClick(Sender: TObject);
begin
  WaveRecorder.SelectFormat;
  WaveRecorder.SaveFormatInRegistry(HKEY_LOCAL_MACHINE,'\SOFTWARE\SATELITSOFT\RBO\','Recformat');
end;

procedure TFormCapture.StartBtnClick(Sender: TObject);
begin
  if autorecord=false then
  begin
    if MMWaveSaveDialog1.Execute then waverecorder.FileName:=MMWaveSaveDialog1.FileName;
  end else
  begin
    WaveRecorder.Recording;
    StopBtn.visible:= True;
    StartBtn.visible:= False;
    FormatBtn.Enabled:= False;
    SaveBtn.visible:= False;
  end;
end;

procedure TFormCapture.StopBtnClick(Sender: TObject);
begin
  WaveRecorder.Stop;
  //SaveBtn.OnClick(self);
end;

procedure TFormCapture.Timer1Timer(Sender: TObject);
begin
   total.Caption := msectotime(WaveRecorder.Position);
   if autorecord=true then
   begin
    if strtoint(resultmin)>=bsSkinSpinEdit1.Value then stopbtn.OnClick(Self);
   end;
end;


procedure TFormCapture.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  //width:=0;
  //height:=0;
  FormCapture.FormStyle:=fsnormal;
  FormCapture.Visible:=false;
  //mainform.AutoArrange1.Click;
end;

procedure TFormCapture.lockClick(Sender: TObject);
begin
  if lock.Checked=true then autorecord:=true else autorecord:=false;
end;

procedure TFormCapture.WaveRecorderStop(Sender: TObject);
begin
  StopBtn.visible := not True;
  StartBtn.visible := not False;
  FormatBtn.Enabled:= not False;
  WaveRecorder.Stop;
end;

procedure TFormCapture.FormCreate(Sender: TObject);
begin
  resultmin:='-1';
end;

end.
